 ; Ŀ
 ;   Moo - Partial menu load with explanatory notes.                       
 ;   Copyright 2002, 2005 by Rocket Software Ltd.                          
 ;   The online help has several fairly intelligible pages on menu         
 ;   management in the usual amorphous arrangement.                        
 ; 

 ; This is rough code to allow for .cui and .cuix files, and needs to be cut
 ; into the main code.
 ; Ŀ
 ;   Mna - Reload the auxiliary menu.                                      
 ;   Copyright 2003, 2010 by Rocket Software Ltd.                          
 ;                                                                         
 ; 
 (DEFUN C:MNA (/ namu)
  (setvar "cmdecho" 0)
  (setq namu "auxelec")
  (command "menuunload" namu)  ; by group name in the file, not file name
 ; Ŀ
 ;   Load the partial menu.                                                
 ;   Explicitly using the .mnu extension should force a recompile, or      
 ;   one could just erase the .mns and .mnc files.                         
 ; 
  (if (findfile (strcat namu ".cui"))
      (command "menuload" namu)                  ; normal load
      (command "menuload" (strcat namu ".mnu"))) ; use to force a recompile
 (princ))



 ; Ŀ
 ;   Subroutine Moo - Partial menu Load and Install.                       
 ;   Arguments: Namu, a menu file name (no extension).                     
 ;              Menm, a menu group name.                                   
 ;   Returns nothing, calls nothing.                                       
 ; 
 (DEFUN MOO (namu menm /)
 ; Ŀ
 ;   Loading main menus with the Menu command recompiles the menu and      
 ;   ditches any partial loads, so it should be avoided here.              
 ; 
 ;(command "menu" (strcat namu ".mnu"))
 ; Ŀ
 ;   Menu loads etc. within a menu use the leading $, menucmd calls        
 ;   don't require it and won't work with it.                              
 ; 
 ;(menucmd "$P16=")               ; won't work
 ; Ŀ
 ;   The online help says:                                                 
 ;   "To determine if a particular menu file is currently loaded, use      
 ;    the following syntax with any Pop menu item:"                        
 ;   Unfortunately it doesn't seem to work.                                
 ; 
 ;(print (menucmd (strcat menm ".pop1=?")))
 ; Ŀ
 ;   Unload a menu by the menu group name, not the file name.              
 ;   Loading an already loaded menu hangs the command with an error, so    
 ;   have to unload it first.                                              
 ;   It isn't necessary to reload a partial menu unless it has changed -   
 ;   partial loads are saved between acad sessions.                        
 ; 
  (command "menuunload" menm)      ; by group name in the file, not file name
 ; Ŀ
 ;   Load the partial menu.                                                
 ;   Explicitly using the .mnu extension should force a recompile, or      
 ;   one could just erase the .mns and .mnc files.                         
 ; 
; (command "menuload" (strcat namu ".mnu")) ; use to force a recompile
  (command "menuload" namu)                 ; normal load
 ; Ŀ
 ;   Put the pop1 section from the partial menu in front of pop24.         
 ;   Since there is no pop24 in the main file this becomes the last        
 ;   (furthest right) menu.                                                
 ; 
  (menucmd (strcat "P24=+" menm ".Pop1"))
 (princ))
 ; Ŀ
 ;   Subroutine Moo end.                                                   
 ; 

 ; Ŀ
 ;   Omo - remove the Auxelec menu.                                        
 ; 
 (DEFUN C:OMO (/ menm)
  (setvar "cmdecho" 0)
  (setq menm "auxelec")        ; group name
  (command "menuunload" menm)  ; by group name in the file, not file name
 (princ))

 ; Ŀ
 ;   Moo.                                                                  
 ; 
 (DEFUN C:MOO (/ namu menm)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Typically the menu file name and group name should be the same.       
 ; 
  (setq namu "auxelec")      ; file name
  (setq menm "auxelec")      ; group name
 ; Ŀ
 ;   See if a menu file is available.                                      
 ; 
  (if (or (findfile (strcat namu ".mnu"))
          (findfile (strcat namu ".mns"))
          (findfile (strcat namu ".mnc")))
      (moo namu menm)
      (prompt (strcat "Can't find menu file "
                      (strcase (substr namu 1 1))
                      (strcase (substr namu 2) t) ".")))
 ; Ŀ
 ;   Other stuff you can do.                                               
 ; 
 ; (menucmd "P15.5=~")             ; disable pop15 item 5
 ; (menucmd "P15.5=!")             ; checkmark pop15 item 5
 ; (menucmd "P15.5=")              ; restore pop15 item 5 to base state
 ; (menucmd "p5=-")                ; remove a pop menu
 ; (menucmd "electric.pop5=-")     ; doesn't seem to work
 (princ))
